;; Fitting common example dataset from:
;; Grasela and Donn (1985), Developmental 
;; Pharmacology and Therapeutics, 8, 374-383.
;; Description: Beyond structural version of the model:
;;		1 CMT
;;		Block IIV on CL+V
;;		Add+Prop Error
$PROB PPK Model for Phenobarbitol in neonates

$INPUT
ID TIME AMT WT APGR DV MDV EVID
$DATA data.csv IGNORE=@
$SUBROUTINE ADVAN1 TRANS2 

$PK
TVCL = THETA(1)
CL = TVCL*EXP(ETA(1))

TVV = THETA(2)
V = TVV*EXP(ETA(2))

S1 = V
RUVADD = THETA(3)
RUVPRO = THETA(4)

$ERROR
IPRED = F
 
W = SQRT(RUVADD*RUVADD + IPRED*IPRED*RUVPRO*RUVPRO)
 
Y =  IPRED+W*EPS(1)
IRES = DV - IPRED
IWRES = IRES/W

$THETA
(0, 0.01) ; CL
(0, 1) ; V
(0, 0.1) ; RUVADD
(0, 0.1) ; RUVPRO

$OMEGA BLOCK(2)
1 ; IIVCL
0.1 1 ; IIVV

$SIGMA
1 FIX


$ESTIMATION METHOD=1 INTER MAXEVAL=9999 PRINT=1
$COV	PRINT=E UNCONDITIONAL

; Monolithic table
$TAB ID TIME AMT WT APGR MDV EVID IPRED IRES IWRES
	 CL V ETAS(1:LAST) 
	 PRED CRES CWRES NPDE NOPRINT FORMAT=s1PE13.7 
	 FILE=run7tab